(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14473,        436]*)
(*NotebookOutlinePosition[     15173,        460]*)
(*  CellTagsIndexPosition[     15129,        456]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["N\[UAcute]meros de Fibonacci", "Title"],

Cell[CellGroupData[{

Cell["Descripci\[OAcute]n de la pr\[AAcute]ctica", "Section"],

Cell[TextData[{
  "En esta pr\[AAcute]ctica estudiaremos la sucesi\[OAcute]n de Fibonacci con \
distintas t\[EAcute]cnicas que pueden generalizarse a otras sucesiones \
recurrentes de tipo lineal. Dicha sucesi\[OAcute]n aparece en el ",
  StyleBox["Liber abacci",
    FontSlant->"Italic"],
  " que el matem\[AAcute]tico italiano ",
  StyleBox["Leonardo de Pisa ",
    FontSlant->"Italic"],
  "(1170 - 1250) conocido como ",
  StyleBox["Fibonacci",
    FontSlant->"Italic"],
  ", contracci\[OAcute]n de ",
  StyleBox["filius Bonacci",
    FontSlant->"Italic"],
  ", es decir ",
  StyleBox["el hijo de Bonacci, ",
    FontSlant->"Italic"],
  "public\[OAcute] en el a\[NTilde]o 1202; libro que tuvo extraordinaria \
influencia pues en \[EAcute]l se introdujo por primera vez en Europa el \
sistema de numeraci\[OAcute]n decimal indoar\[AAcute]bigo que todav\[IAcute]a \
usamos. En el citado libro aparece el siguiente problema:\n",
  StyleBox[
  "\"Una pareja de conejos tarda un mes en alcanzar la edad f\[EAcute]rtil y, \
a partir de ese momento, al final de cada mes engendra una pareja de conejos, \
que a su vez, tras ser f\[EAcute]rtiles, engendrar\[AAcute]n al final de cada \
mes una pareja de conejos. \[DownQuestion]Cu\[AAcute]ntas parejas de conejos \
habr\[AAcute] al principio del n-\[EAcute]simo mes?\"",
    FontSlant->"Italic"],
  "\nLa respuesta a la pregunta anterior es un n\[UAcute]mero que se llama el \
n-\[EAcute]simo n\[UAcute]mero de Fibonacci y se representa por ",
  Cell[BoxData[
      \(TraditionalForm\`F\_n = F[n]\)]],
  ".  Dichos n\[UAcute]meros aparecen en situaciones muy diversas (por \
ejemplo, est\[AAcute]n escondidos en el conjunto de Mandelbrot y relacionados \
con la proporci\[OAcute]n \[AAcute]urea) y son tantos los resultados \
interesantes relacionados con ellos que hay una revista ",
  StyleBox["The",
    FontSlant->"Italic"],
  " ",
  StyleBox["Fibonacci Quarterly",
    FontSlant->"Italic"],
  " publicada por la ",
  StyleBox["Fibonacci Association",
    FontSlant->"Italic"],
  " que est\[AAcute] dedicada exclusivamente a publicarlos. En Internet \
puedes encontrar much\[IAcute]sima informaci\[OAcute]n sobre la sucesi\
\[OAcute]n de Fibonacci. Dos sitios interesantes son ",
  StyleBox[
  "www-history.mcs.st-and.ac.uk./~history/Mathematicians/Fibonacci.html",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True}],
  " y ",
  StyleBox["www.ee.surrey.ac.uk/Personal/R.Knott/Fibonacci/fib.html",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True}],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Subsubsection"],

Cell[TextData[{
  "Es claro que ",
  Cell[BoxData[
      \(TraditionalForm\`F[1] = \(F[2] = 1\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`F[3] = 2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`F[4] = 3\)]],
  "... \n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " Establece ",
  StyleBox["razonadamente",
    FontSlant->"Italic"],
  " una relaci\[OAcute]n de recurrencia entre ",
  Cell[BoxData[
      \(TraditionalForm\`F[n], \ F[n - 1]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`F[n - 2]\)]],
  ". Utiliza dicha relaci\[OAcute]n para que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcule los n\[UAcute]meros de Fibonacci. Quiero que hagas esto de tres \
formas:\n",
  StyleBox["a1)",
    FontWeight->"Bold"],
  " Definiendo la relaci\[OAcute]n de recurrencia con las condiciones \
iniciales sin pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que recuerde los valores ya calculados.\n",
  StyleBox["a2)",
    FontWeight->"Bold"],
  " Definiendo dicha relaci\[OAcute]n de recurrencia con las condiciones \
iniciales de modo que cuando ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcule un valor ",
  StyleBox["F",
    FontSlant->"Italic"],
  "[n] recuerde los anteriores.\n",
  StyleBox["a3)",
    FontWeight->"Bold"],
  " Por medio de un bucle, usando un \"For\" o un \"Do\".\n",
  StyleBox["a4)",
    FontWeight->"Bold"],
  " Compara, usando el comando \"Timing\", el tiempo que invierte ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " en calcular los primeros 30 n\[UAcute]meros de Fibonacci en el primer \
caso y los primeros 1000 n\[UAcute]meros de Fibonacci en los otros dos casos. \
Comenta qu\[EAcute] procedimiento te parece mejor. \n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Calcula la soluci\[OAcute]n de dicha relaci\[OAcute]n de recurrencia y \
define una funci\[OAcute]n \"fib[n]\" que sea igual a dicha soluci\[OAcute]n \
(usa tambi\[EAcute]n \"Simplify\" para simplificarla y quitar \
ra\[IAcute]ces). Es decir, fib[n] te proporciona expl\[IAcute]citamente como \
funci\[OAcute]n de n el n\[UAcute]mero ",
  StyleBox["F",
    FontSlant->"Italic"],
  "[n]. Calcula con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " los primeros 30 valores de \"fib[n]\" y comprueba que coinciden con los \
antes obtenidos. "
}], "Text"],

Cell[TextData[{
  "Sugerencias. Ensaya como soluci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n\)]],
  " y deduce que ",
  StyleBox["x",
    FontSlant->"Italic"],
  " debe ser soluci\[OAcute]n de la ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 - x - 1 = 0\)]],
  ". Calcula con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dichas soluciones. Sean estas ",
  StyleBox["a",
    FontSlant->"Italic"],
  " y ",
  StyleBox["b",
    FontSlant->"Italic"],
  ". Comprueba con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que cualquier expresi\[OAcute]n de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\ a\^n + \[Beta]\ b\^\(\(n\)\(\ \)\)\)]],
  "donde \[Alpha] y \[Beta] son n\[UAcute]meros reales cualesquiera es soluci\
\[OAcute]n de la ecuaci\[OAcute]n de recurrencia. Usa para ello \
\"FullSimplify[",
  StyleBox["expr1==expr2",
    FontSlant->"Italic"],
  "]\". En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5 puedes usar \"FullSimplify[",
  StyleBox["expr1==expr2,Assumptions",
    FontSlant->"Italic"],
  "]\" donde \"Assumptions\" puede ser una informaci\[OAcute]n sobre el tipo \
de variables que aparecen en \"expr1\" o \"expr2\", por ejemplo, \"",
  StyleBox["n\[Element]",
    FontSlant->"Italic"],
  "Integers\". Esto no funciona en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3 donde es preciso declarar expl\[IAcute]citamente que ",
  StyleBox["n",
    FontSlant->"Italic"],
  " es un entero y ampliar la funci\[OAcute]n IntegerQ como sigue: "
}], "Text"],

Cell[BoxData[{
    \(entero[x_] := IntegerQ[x]\), 
    \(entero[x_\ y_] := entero[x] && entero[y]\), 
    \(entero[x_\  + \ y_] := entero[x] && entero[y]\)}], "Input"],

Cell[BoxData[
    \(\(n /: IntegerQ[n] = True;\)\)], "Input"],

Cell[TextData[{
  "Calcula con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " \[Alpha] y \[Beta] (y simplif\[IAcute]calas) para que se cumplan las \
condiciones iniciales. Con alg\[UAcute]n detalle adicional ya puedes definir \
la funci\[OAcute]n fib[n]."
}], "Text"],

Cell[TextData[{
  StyleBox["c)",
    FontWeight->"Bold"],
  " Si tratas de calcular (con Mathematica 3) fib[126] ver\[AAcute]s que no \
devuelve de forma expl\[IAcute]cita un n\[UAcute]mero entero porque no \
realiza de forma completa la simplificaci\[OAcute]n. Puedes evitar esto de la \
siguiente forma. Uno de los valores ",
  StyleBox["a",
    FontSlant->"Italic"],
  " o ",
  StyleBox["b",
    FontSlant->"Italic"],
  " que has calculado antes es menor que 1 en valor absoluto; supongamos que \
sea ",
  StyleBox["b",
    FontSlant->"Italic"],
  " este valor. Entonces ",
  Cell[BoxData[
      \(TraditionalForm\`b^n\)]],
  " converge r\[AAcute]pidamente a cero y, como fib[n] debe ser un entero, \
deducimos que fib[n] es el entero m\[AAcute]s pr\[OAcute]ximo a ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\ a^n + \(\[Beta]\ b^n\ \)\)]],
  ". La funci\[OAcute]n Round[x] proporciona el entero m\[AAcute]s \
pr\[OAcute]ximo a x. Puedes ahora modificar de forma apropiada la funci\
\[OAcute]n fib[n] para que su salida sea siempre de forma expl\[IAcute]cita \
un entero. Calcula con ella los primeros 130 n\[UAcute]meros de Fibonacci."
}], "Text"],

Cell[TextData[{
  "Nota. Al calcular fib[n] te habr\[AAcute] aparecido el n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\(1 + \@5\)\/2\)]],
  "que se llama ",
  StyleBox["n\[UAcute]mero \[AAcute]ureo",
    FontSlant->"Italic"],
  " o ",
  StyleBox["raz\[OAcute]n \[AAcute]urea",
    FontSlant->"Italic"],
  ". Se ha escrito tanto sobre este n\[UAcute]mero que yo no a\[NTilde]adir\
\[EAcute] ni una palabra m\[AAcute]s. Si tienes curiosidad busca informaci\
\[OAcute]n en Internet. Por supuesto, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " incluye la constante GoldenRatio. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Subsubsection"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Expresa la relaci\[OAcute]n de recurrencia del ejercicio anterior en la \
forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(u[n]\), "=", 
          RowBox[{
            StyleBox["A",
              FontSlant->"Italic"], 
            StyleBox[
              FormBox[
                StyleBox[\(u[n - 1]\),
                  FontWeight->"Plain"],
                "TraditionalForm"],
              FontWeight->"Bold"], "   ", \((n \[GreaterEqual] 2)\)}]}], 
        TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`u[n]\)]],
  " = ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", "\[NegativeThinSpace]", GridBox[{
              {\(F[n + 1]\)},
              {\(F[n]\)}
              }], ")"}], TraditionalForm]]],
  " y ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es una matriz apropiada. Por tanto  ",
  Cell[BoxData[
      \(TraditionalForm\`u[n]\)]],
  " =",
  Cell[BoxData[
      \(TraditionalForm\`A\^\(n - 1\)\)]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(u[1]\),
          FontWeight->"Plain"], TraditionalForm]]],
  ", para todo ",
  StyleBox["n",
    FontSlant->"Italic"],
  " \[GreaterEqual] 2. En consecuencia, podemos calcular ",
  Cell[BoxData[
      \(TraditionalForm\`F[n]\)]],
  " calculando ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(A\^\(n - 1\)\), 
          FormBox[\(u[1]\),
            "TraditionalForm"], " "}], TraditionalForm]]],
  ". ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando espec\[IAcute]fico para calcular potencias de una \
matriz. Utiliza dicho comando para definir una funci\[OAcute]n \"fibmatrix[n]\
\" que proporcione como respuesta el n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`F[n]\)]],
  " y \[UAcute]sala para calcular los primeros 120 n\[UAcute]meros de \
Fibonacci.  \n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Es muy f\[AAcute]cil calcular ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(A\^\(n - 1\)\), 
          FormBox[\(u[1]\),
            "TraditionalForm"]}], TraditionalForm]]],
  " si conocemos los valores propios de la matriz ",
  StyleBox["A",
    FontSlant->"Italic"],
  ". Sean \[Lambda] y \[Mu] los valores propios de ",
  StyleBox["A",
    FontSlant->"Italic"],
  " con vectores propios ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\[Lambda]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_\[Mu]\ \)\)]],
  " (que debes calcular con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Calcula ",
  StyleBox["c",
    FontSlant->"Italic"],
  ", ",
  StyleBox["d",
    FontSlant->"Italic"],
  " tales que ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(u[1]\), "=", 
          RowBox[{
            RowBox[{"c", " ", 
              FormBox[\(x\_\[Lambda]\),
                "TraditionalForm"]}], "+", " ", 
            RowBox[{"d", " ", 
              FormBox[\(x\_\[Mu]\),
                "TraditionalForm"]}]}]}], TraditionalForm]]],
  " y comprueba que la segunda componente del vector ",
  Cell[BoxData[
      \(TraditionalForm\`A\^\(n - 1\)\)]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(u[1]\),
          FontWeight->"Plain"], TraditionalForm]]],
  " es igual a fib[n].\nSugerencia. Comprueba con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " (usando \"FullSimplify[",
  StyleBox["expr",
    FontSlant->"Italic"],
  "1==expr2]\") que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(A\^\(n - 1\)\) u[1] = 
        c\ \(\[Lambda]\^\(n - 1\)\) x\_\[Lambda]\  + 
          \(d\ \(\[Mu]\^\(n - 1\)\) x\_\[Mu]\ \)\)]],
  ". "
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 45, 0, 99, "Title"],

Cell[CellGroupData[{
Cell[1824, 55, 61, 0, 93, "Section"],
Cell[1888, 57, 2564, 57, 429, "Text"],

Cell[CellGroupData[{
Cell[4477, 118, 36, 0, 67, "Subsubsection"],
Cell[4516, 120, 2353, 69, 451, "Text"],
Cell[6872, 191, 1572, 47, 171, "Text"],
Cell[8447, 240, 167, 3, 124, "Input"],
Cell[8617, 245, 61, 1, 72, "Input"],
Cell[8681, 248, 279, 7, 67, "Text"],
Cell[8963, 257, 1159, 27, 171, "Text"],
Cell[10125, 286, 615, 16, 101, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10777, 307, 36, 0, 67, "Subsubsection"],
Cell[10816, 309, 3629, 123, 290, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

